/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.image.BufferedImage;
import ocr.ImageUtils;

public class ImageDeskew {
    private BufferedImage cImage;
    private double cAlphaStart = -20.0;
    private double cAlphaStep = 0.2;
    private int cSteps = 200;
    private double[] cSinA;
    private double[] cCosA;
    private double cDMin;
    private double cDStep = 1.0;
    private int cDCount;
    private int[] cHMatrix;

    public ImageDeskew(BufferedImage image) {
        this.cImage = image;
    }

    public double getSkewAngle() {
        double sum = 0.0;
        double count = 0.0;
        this.calc();
        HoughLine[] hl = this.getTop(20);
        if (hl.length >= 20) {
            for (int i = 0; i < 19; ++i) {
                sum += hl[i].alpha;
                count += 1.0;
            }
            return sum / count;
        }
        return 0.0;
    }

    private HoughLine[] getTop(int count) {
        int i;
        HoughLine[] hl = new HoughLine[count];
        for (int i2 = 0; i2 < count; ++i2) {
            hl[i2] = new HoughLine();
        }
        int j = 0;
        for (i = 0; i < count - 1; ++i) {
            hl[i] = new HoughLine();
        }
        for (i = 0; i < this.cHMatrix.length - 1; ++i) {
            if (this.cHMatrix[i] <= hl[count - 1].count) continue;
            hl[count - 1].count = this.cHMatrix[i];
            hl[count - 1].index = i;
            for (j = count - 1; j > 0 && hl[j].count > hl[j - 1].count; --j) {
                HoughLine tmp = hl[j];
                hl[j] = hl[j - 1];
                hl[j - 1] = tmp;
            }
        }
        for (i = 0; i < count - 1; ++i) {
            int dIndex = hl[i].index / this.cSteps;
            int alphaIndex = hl[i].index - dIndex * this.cSteps;
            hl[i].alpha = this.getAlpha(alphaIndex);
            hl[i].d = (double)dIndex + this.cDMin;
        }
        return hl;
    }

    private void calc() {
        int hMin = (int)((double)this.cImage.getHeight() / 4.0);
        int hMax = (int)((double)this.cImage.getHeight() * 3.0 / 4.0);
        this.init();
        for (int y = hMin; y < hMax; ++y) {
            for (int x = 1; x < this.cImage.getWidth() - 2; ++x) {
                if (!ImageUtils.isBlack(this.cImage, x, y) || ImageUtils.isBlack(this.cImage, x, y + 1)) continue;
                this.calc(x, y);
            }
        }
    }

    private void calc(int x, int y) {
        for (int alpha = 0; alpha < this.cSteps - 1; ++alpha) {
            double d = (double)y * this.cCosA[alpha] - (double)x * this.cSinA[alpha];
            int dIndex = (int)(d - this.cDMin);
            int index = dIndex * this.cSteps + alpha;
            try {
                int n = index;
                this.cHMatrix[n] = this.cHMatrix[n] + 1;
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
    }

    private void init() {
        this.cSinA = new double[this.cSteps - 1];
        this.cCosA = new double[this.cSteps - 1];
        for (int i = 0; i < this.cSteps - 1; ++i) {
            double angle = this.getAlpha(i) * Math.PI / 180.0;
            this.cSinA[i] = Math.sin(angle);
            this.cCosA[i] = Math.cos(angle);
        }
        this.cDMin = -this.cImage.getWidth();
        this.cDCount = (int)(2.0 * (double)(this.cImage.getWidth() + this.cImage.getHeight()) / this.cDStep);
        this.cHMatrix = new int[this.cDCount * this.cSteps];
    }

    public double getAlpha(int index) {
        return this.cAlphaStart + (double)index * this.cAlphaStep;
    }

    public class HoughLine {
        public int count = 0;
        public int index = 0;
        public double alpha;
        public double d;
    }
}

