/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import ocr.ApplicationInstanceListener;
import ocr.ApplicationInstanceManager;
import ocr.DocImagePanel;
import ocr.ImageFilter;

public class ocrgui
extends JFrame {
    private boolean Debug = true;
    private boolean OCRServerPresentLocally = false;
    String ocr_server_url = "http://www.kannadao.com/servlet/ocrserver_caller";
    String local_ocr_cmd = "java -jar D:\\prakash\\ocr\\dist\\ocr.jar";
    String image_folder = "";
    private String ImageFile = null;
    private String ImageFilePath = null;
    private String OcrOutFile;
    private String Msg = null;
    static int PanelHt;
    static int PanelWidth;
    static int ParamPanelWidth;
    static int ImagePanelWidth;
    static int PREF_BODY_HEIGHT;
    static int OCRClientReqTimeOut;
    float SFactor = 1.0f;
    float prev_factor = 1.0f;
    float CORRECTION_FACTOR = 0.85f;
    boolean force_scale;
    Dimension ScreenSize;
    Dimension frameSize;
    DocImagePanel di_pane;
    SimpleDateFormat formatter;
    PrintStream LogPS = null;
    private JButton Binarize_Button;
    private JButton CallDigitize_jButton;
    private JFrame Config_jFrame;
    private JMenuItem Exit_jMenuItem;
    private JMenu File_jMenu;
    private static JLabel GValue_jLabel;
    private JFileChooser Image_jFileChooser;
    private JMenuItem OpenImageDoc_jMenuItem;
    private JMenu Options_jMenu;
    private JPanel ParamPanel;
    private JButton ScaleImage_Button;
    private JButton UserHSpaceBetwTextBlk_Button;
    private JFormattedTextField UserHSpaceBetwTxtBlk_FormattedTextField;
    private JButton UserLetterHeight_Button;
    private JFormattedTextField UserLetterHt_FormattedTextField;
    private JSpinner UserScaleFactor_jSpinner;
    private JButton UserVSpaceBetwTextBlk_Button;
    private JFormattedTextField UserVSpaceBetwTxtBlk_FormattedTextField;
    private JSpinner UserWhiteStart_jSpinner;
    private JLabel image_folder_jLabel;
    private JTextField image_folder_jTextField;
    private JMenuItem jParams;
    private JLabel ocr_server_url_jLabel;
    private JTextField ocr_server_url_jTextField;
    private JMenuBar ocrguiMenuBar;

    public ocrgui() {
        if (!this.ReadConfigFile()) {
            this.Msg = "Error: Cannot read config file. Terminating...";
            System.out.println(this.Msg);
            JOptionPane.showMessageDialog(this, this.Msg, "Config File Open Error", 0);
            System.exit(0);
        }
        this.initComponents();
        this.initOtherComponents();
    }

    private static void createAndShowGUI() {
        ocrgui frame = new ocrgui();
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private void initOtherComponents() {
        String jarpath = null;
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            int pixels_per_inch = tk.getScreenResolution();
            this.ScreenSize = tk.getScreenSize();
            PanelHt = this.ScreenSize.height - (int)((double)this.ScreenSize.height * 0.1) - 80;
            PanelWidth = this.ScreenSize.width - 360;
            ParamPanelWidth = 200;
            ImagePanelWidth = PanelWidth - ParamPanelWidth;
            this.frameSize = this.ScreenSize;
            this.ParamPanel.setSize(ParamPanelWidth, PanelHt);
            GValue_jLabel.setVisible(false);
            this.di_pane = new DocImagePanel();
            this.di_pane.setDebug(this.Debug);
            this.add((Component)this.di_pane, "West");
            this.Image_jFileChooser.setCurrentDirectory(new File(this.image_folder));
            this.Image_jFileChooser.addChoosableFileFilter(new ImageFilter());
            this.Image_jFileChooser.setAcceptAllFileFilterUsed(false);
            this.force_scale = false;
            this.formatter = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z :", Locale.ENGLISH);
            jarpath = new File(ocrgui.class.getResource("ocrgui.class").getPath()).getParentFile().getParent();
            if (jarpath.startsWith("file:")) {
                jarpath = jarpath.substring(6, jarpath.length() - 1);
            }
            if (jarpath.endsWith(".jar")) {
                jarpath = new File(jarpath).getParent();
            }
            File logFile = new File(jarpath + "\\kanscan.log");
            this.LogPS = new PrintStream(new FileOutputStream(logFile, true));
            System.setOut(this.LogPS);
            this.ocr_server_url_jTextField.setText("");
            this.image_folder_jTextField.setText(this.image_folder);
        }
        catch (FileNotFoundException fe) {
            this.Msg = "Error - Cannot open log file - " + jarpath + "\\kanscan.log";
            System.out.println(this.Msg);
            JOptionPane.showMessageDialog(this, this.Msg, "File Open Error", 0);
        }
    }

    private void invokeOCRServer() {
        block14: {
            block13: {
                try {
                    if (this.ImageFilePath == null) {
                        this.Msg = "Please select an image file to digitize.";
                        JOptionPane.showMessageDialog(this, this.Msg, "Image File Open Error", 0);
                        return;
                    }
                    Process p = null;
                    int letterht = 0;
                    int hspace = 0;
                    int vspace = 0;
                    int whitethshld = 0;
                    Object obj = this.UserLetterHt_FormattedTextField.getValue();
                    letterht = obj == null ? 0 : (int)((double)Integer.parseInt(obj.toString()) * 0.9);
                    if (letterht < PREF_BODY_HEIGHT) {
                        JOptionPane.showMessageDialog(this, "Letter Height is less than 15 pixels.\nImage resolution is low. Cannot digitize image.", "Low Resolution", 0);
                        return;
                    }
                    if (letterht > PREF_BODY_HEIGHT * 3) {
                        JOptionPane.showMessageDialog(this, "Image resolution is very high. Cannot digitize image.", "High Resolution", 0);
                        return;
                    }
                    obj = this.UserHSpaceBetwTxtBlk_FormattedTextField.getValue();
                    hspace = obj == null ? 0 : (int)((float)Integer.parseInt(obj.toString()) * this.CORRECTION_FACTOR);
                    obj = this.UserVSpaceBetwTxtBlk_FormattedTextField.getValue();
                    vspace = obj == null ? 0 : (int)((float)Integer.parseInt(obj.toString()) * this.CORRECTION_FACTOR);
                    obj = this.UserWhiteStart_jSpinner.getValue();
                    whitethshld = obj == null ? 0 : Integer.parseInt(obj.toString());
                    if (whitethshld < 130 || whitethshld > 230) {
                        JOptionPane.showMessageDialog(this, "White Threshold value is too low or too high.\nPreferred values between 130 and 230. Please, verify.", "White Threshold Value Error", 0);
                        return;
                    }
                    this.CallDigitize_jButton.setText("Please Wait...");
                    this.CallDigitize_jButton.setEnabled(false);
                    System.out.println(this.formatter.format(new Date()) + "Invoking OCR Server...");
                    this.OcrOutFile = null;
                    if (this.OCRServerPresentLocally) {
                        String inputLine;
                        String cmd = this.local_ocr_cmd + " " + this.ImageFilePath + " " + hspace + " " + vspace + " " + letterht + " " + whitethshld;
                        if (this.Debug) {
                            System.out.println(cmd);
                        }
                        p = Runtime.getRuntime().exec(cmd);
                        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((inputLine = in.readLine()) != null) {
                            System.out.println(inputLine);
                        }
                        in.close();
                        File pf = new File(this.ImageFilePath);
                        this.OcrOutFile = pf.getParent() + File.separator + "ocrout" + File.separator + pf.getName().substring(0, pf.getName().indexOf(46)) + "_ocr.txt";
                    } else {
                        String params = this.ImageFile + " " + hspace + " " + vspace + " " + letterht + " " + whitethshld;
                        this.call_remote_ocr_server(params);
                    }
                }
                catch (IOException e) {
                    System.out.println("Error invoking OCR server...");
                    JOptionPane.showMessageDialog(this, "There was an error while invoking OCR Server. Please, check log file for details.", "Invoke OCR Server Error", 0);
                    if (!this.Debug) break block13;
                    e.printStackTrace();
                }
            }
            try {
                if (this.OcrOutFile != null) {
                    System.out.println(this.formatter.format(new Date()) + "Digitization completed - OCRFile is " + this.OcrOutFile);
                    Runtime.getRuntime().exec("notepad.exe " + this.OcrOutFile);
                }
            }
            catch (Exception e) {
                System.out.println("Error lauching notepad.exe...");
                JOptionPane.showMessageDialog(this, "There was an error while opening OCR file using notepad.\nPlease, check log file for details.", "View OCR File Error", 0);
                if (!this.Debug) break block14;
                e.printStackTrace();
            }
        }
        this.CallDigitize_jButton.setText("Digitize Image");
        this.CallDigitize_jButton.setEnabled(true);
    }

    private void call_remote_ocr_server(String params) {
        block7: {
            try {
                String msg_from_server;
                System.out.println("OCR server is on a remote server.");
                if (!this.uploadImage()) {
                    return;
                }
                URL url = new URL(this.ocr_server_url);
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                connection.setReadTimeout(OCRClientReqTimeOut);
                connection.setRequestProperty("Content-Type", "OCRCommand");
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.write("params=" + URLEncoder.encode(params, "UTF-8"));
                out.close();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((msg_from_server = in.readLine()) != null) {
                    if (msg_from_server.startsWith("##FileName")) {
                        if (this.downloadFileFromRUL(msg_from_server)) continue;
                        this.Msg = "Error while reading OCR file from remote server...";
                        System.out.println(this.Msg);
                        JOptionPane.showMessageDialog(this, this.Msg, "OCR File Receive Error", 0);
                        continue;
                    }
                    if (msg_from_server.startsWith("Remote OCRServer - Error")) {
                        System.out.println(msg_from_server);
                        JOptionPane.showMessageDialog(this, msg_from_server, "Remote OCR Error", 0);
                        continue;
                    }
                    System.out.println(msg_from_server);
                }
                in.close();
            }
            catch (MalformedURLException murl) {
                this.Msg = "Error while invoking remote OCR server...\nPlease, check if the url address for remote ocr server is correct.";
                System.out.println(this.Msg);
                JOptionPane.showMessageDialog(this, this.Msg, "Invoke OCR Server Error", 0);
            }
            catch (IOException io) {
                this.Msg = "Error while invoking remote OCR server...\nPlease, check if the url address for remote ocr server is correct.\nAnd, if network is available.";
                System.out.println(this.Msg);
                JOptionPane.showMessageDialog(this, this.Msg, "Invoke OCR Server Error", 0);
                if (!this.Debug) break block7;
                io.printStackTrace();
            }
        }
    }

    private boolean uploadImage() {
        try {
            String msg_from_server;
            File pf = new File(this.ImageFilePath);
            BufferedImage bufferedImage = ImageIO.read(pf);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteStream);
            byte[] buf = byteStream.toByteArray();
            URL url = new URL(this.ocr_server_url);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setChunkedStreamingMode(1000);
            con.setRequestProperty("Content-Type", "Image");
            con.setRequestMethod("POST");
            OutputStream os = con.getOutputStream();
            os.write(buf);
            os.flush();
            os.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((msg_from_server = in.readLine()) != null) {
                System.out.println(msg_from_server);
            }
            in.close();
            return true;
        }
        catch (MalformedURLException murl) {
            this.Msg = "Error while uploading image to remote OCR server...\nPlease, check if the url for remote ocr server is correct.";
            System.out.println(this.Msg);
            JOptionPane.showMessageDialog(this, this.Msg, "Upload Image Error", 0);
            return false;
        }
        catch (IOException io) {
            this.Msg = "Error while uploading image to remote OCR server...\nPlease, check if the url for remote ocr server is correct.\nAnd, if network is available.";
            System.out.println(this.Msg);
            JOptionPane.showMessageDialog(this, this.Msg, "Upload Image Error", 0);
            if (this.Debug) {
                System.out.println(io.getMessage());
            }
            return false;
        }
    }

    private void downloadOCRFile(BufferedReader in) {
        block4: {
            try {
                String msg_from_server;
                int index = this.ImageFilePath.indexOf(46);
                if (index == -1) {
                    return;
                }
                String ocrfile = this.ImageFilePath.substring(0, index) + "_r_ocr.txt";
                System.out.println("OCR out file is " + ocrfile);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ocrfile), "UTF8"));
                while ((msg_from_server = in.readLine()) != null && !msg_from_server.startsWith("##File End##")) {
                    out.write(msg_from_server);
                    out.newLine();
                }
                out.close();
                this.OcrOutFile = ocrfile;
            }
            catch (IOException io) {
                this.Msg = "Error while reading OCR file from remote server...";
                System.out.println(this.Msg);
                JOptionPane.showMessageDialog(this, this.Msg, "OCR File Receive Error", 0);
                if (!this.Debug) break block4;
                io.printStackTrace();
            }
        }
    }

    private boolean downloadFileFromRUL(String msg_from_server) {
        try {
            int index1 = msg_from_server.indexOf(61);
            URL url = new URL(msg_from_server.substring(msg_from_server.indexOf(61) + 1));
            URLConnection con = url.openConnection();
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            index1 = this.ImageFilePath.indexOf(46);
            if (index1 == -1) {
                return false;
            }
            String ocrfile = this.ImageFilePath.substring(0, index1) + "_r_ocr.txt0";
            FileOutputStream out = new FileOutputStream(ocrfile);
            int i = 0;
            byte[] bytesIn = new byte[1024];
            while ((i = in.read(bytesIn)) >= 0) {
                out.write(bytesIn, 0, i);
            }
            out.close();
            in.close();
            File file = new File(ocrfile);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ocrfile = ocrfile.substring(0, ocrfile.length() - 1);
            FileWriter writer = new FileWriter(ocrfile);
            String line = "";
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\r\n");
            }
            writer.close();
            reader.close();
            System.out.println("OCR out file is " + ocrfile);
            file.delete();
            this.OcrOutFile = ocrfile;
            return true;
        }
        catch (MalformedURLException mf) {
            System.out.println(mf.getMessage());
            return false;
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
            return false;
        }
    }

    protected static void displayGreyValue(String s) {
        GValue_jLabel.setVisible(true);
        GValue_jLabel.setText(s);
    }

    boolean ReadConfigFile() {
        try {
            Properties p = new Properties();
            URL url = this.getClass().getResource("kanscanconfig.lic");
            if (url == null) {
                return false;
            }
            p.load(url.openStream());
            this.ocr_server_url = p.getProperty("ocr_server_url");
            this.image_folder = p.getProperty("image_folder");
            if (p.getProperty("messages").equalsIgnoreCase("debugyes")) {
                this.Debug = true;
            }
        }
        catch (FileNotFoundException e) {
            if (this.Debug) {
                System.out.println(e);
            }
            return false;
        }
        catch (IOException e) {
            if (this.Debug) {
                System.out.println(e);
            }
            return false;
        }
        return true;
    }

    void SaveConfigFile() {
        try {
            Properties p = new Properties();
            URL url = this.getClass().getResource("kanscanconfig.lic");
            if (url == null) {
                this.Msg = "Error saving license file...";
                System.out.println(this.Msg);
                JOptionPane.showMessageDialog(this, this.Msg, "Config Save Error", 0);
                return;
            }
            p.load(url.openStream());
            p.put("ocr_server_url", this.ocr_server_url);
            p.put("image_folder", this.image_folder);
            FileOutputStream out = new FileOutputStream(url.getFile());
            p.store(out, "/* properties updated */");
        }
        catch (FileNotFoundException e) {
            if (this.Debug) {
                System.out.println(e);
            }
            return;
        }
        catch (IOException e) {
            if (this.Debug) {
                System.out.println(e);
            }
            return;
        }
    }

    private void initComponents() {
        this.Image_jFileChooser = new JFileChooser();
        this.Config_jFrame = new JFrame();
        this.ocr_server_url_jLabel = new JLabel();
        this.ocr_server_url_jTextField = new JTextField();
        this.image_folder_jLabel = new JLabel();
        this.image_folder_jTextField = new JTextField();
        this.ParamPanel = new JPanel();
        this.UserLetterHt_FormattedTextField = new JFormattedTextField();
        this.UserLetterHeight_Button = new JButton();
        this.UserHSpaceBetwTextBlk_Button = new JButton();
        this.UserHSpaceBetwTxtBlk_FormattedTextField = new JFormattedTextField();
        this.UserVSpaceBetwTextBlk_Button = new JButton();
        this.UserVSpaceBetwTxtBlk_FormattedTextField = new JFormattedTextField();
        this.ScaleImage_Button = new JButton();
        this.UserScaleFactor_jSpinner = new JSpinner();
        this.CallDigitize_jButton = new JButton();
        this.UserWhiteStart_jSpinner = new JSpinner();
        this.Binarize_Button = new JButton();
        GValue_jLabel = new JLabel();
        this.ocrguiMenuBar = new JMenuBar();
        this.File_jMenu = new JMenu();
        this.OpenImageDoc_jMenuItem = new JMenuItem();
        this.Exit_jMenuItem = new JMenuItem();
        this.Options_jMenu = new JMenu();
        this.jParams = new JMenuItem();
        this.Image_jFileChooser.setCurrentDirectory(new File("D:\\"));
        this.Config_jFrame.setTitle("Configurations");
        this.Config_jFrame.setAlwaysOnTop(true);
        this.Config_jFrame.setMinimumSize(new Dimension(533, 198));
        this.Config_jFrame.setName("Configurations");
        this.Config_jFrame.setResizable(false);
        this.Config_jFrame.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent evt) {
                ocrgui.this.Config_jFrameWindowDeactivated(evt);
            }
        });
        this.ocr_server_url_jLabel.setFont(new Font("Tahoma", 0, 12));
        this.ocr_server_url_jLabel.setText("KanScan OCR Server URL");
        this.ocr_server_url_jTextField.setFont(new Font("Tahoma", 0, 12));
        this.image_folder_jLabel.setFont(new Font("Tahoma", 0, 12));
        this.image_folder_jLabel.setText("Default folder for images");
        this.image_folder_jTextField.setFont(new Font("Tahoma", 0, 12));
        GroupLayout Config_jFrameLayout = new GroupLayout(this.Config_jFrame.getContentPane());
        this.Config_jFrame.getContentPane().setLayout(Config_jFrameLayout);
        Config_jFrameLayout.setHorizontalGroup(Config_jFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, Config_jFrameLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(Config_jFrameLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, Config_jFrameLayout.createSequentialGroup().addComponent(this.image_folder_jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE).addComponent(this.image_folder_jTextField, -2, 323, -2)).addGroup(GroupLayout.Alignment.LEADING, Config_jFrameLayout.createSequentialGroup().addComponent(this.ocr_server_url_jLabel).addGap(18, 18, 18).addComponent(this.ocr_server_url_jTextField, -2, 323, -2))).addGap(25, 25, 25)));
        Config_jFrameLayout.setVerticalGroup(Config_jFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(Config_jFrameLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(Config_jFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ocr_server_url_jLabel).addComponent(this.ocr_server_url_jTextField, -2, 31, -2)).addGap(18, 18, 18).addGroup(Config_jFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.image_folder_jLabel).addComponent(this.image_folder_jTextField, -2, 31, -2)).addContainerGap(33, Short.MAX_VALUE)));
        this.setDefaultCloseOperation(3);
        this.setTitle("KanScan v1.0b");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ocrgui.this.formWindowClosing(evt);
            }
        });
        this.ParamPanel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255), 4));
        this.ParamPanel.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        this.ParamPanel.setMinimumSize(new Dimension(200, 460));
        this.ParamPanel.setPreferredSize(new Dimension(200, 460));
        this.UserLetterHt_FormattedTextField.setColumns(3);
        this.UserLetterHt_FormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.UserLetterHt_FormattedTextField.setHorizontalAlignment(11);
        this.UserLetterHt_FormattedTextField.setFont(new Font("Tahoma", 0, 12));
        this.UserLetterHt_FormattedTextField.setPreferredSize(new Dimension(40, 22));
        this.UserLetterHeight_Button.setFont(new Font("Tahoma", 0, 12));
        this.UserLetterHeight_Button.setText("<html>Letter <br />Body Height</html>");
        this.UserLetterHeight_Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.UserLetterHeight_ButtonActionPerformed(evt);
            }
        });
        this.UserHSpaceBetwTextBlk_Button.setFont(new Font("Tahoma", 0, 12));
        this.UserHSpaceBetwTextBlk_Button.setText("<html>Horizontal Space <br />betw Text Blocks</html>");
        this.UserHSpaceBetwTextBlk_Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.UserHSpaceBetwTextBlk_ButtonActionPerformed(evt);
            }
        });
        this.UserHSpaceBetwTxtBlk_FormattedTextField.setColumns(3);
        this.UserHSpaceBetwTxtBlk_FormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.UserHSpaceBetwTxtBlk_FormattedTextField.setHorizontalAlignment(11);
        this.UserHSpaceBetwTxtBlk_FormattedTextField.setFont(new Font("Tahoma 12", 0, 12));
        this.UserHSpaceBetwTxtBlk_FormattedTextField.setPreferredSize(new Dimension(40, 22));
        this.UserVSpaceBetwTextBlk_Button.setFont(new Font("Tahoma", 0, 12));
        this.UserVSpaceBetwTextBlk_Button.setText("<html>Vertical Space  <br />betw Text Blocks</html>");
        this.UserVSpaceBetwTextBlk_Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.UserVSpaceBetwTextBlk_ButtonActionPerformed(evt);
            }
        });
        this.UserVSpaceBetwTxtBlk_FormattedTextField.setColumns(3);
        this.UserVSpaceBetwTxtBlk_FormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.UserVSpaceBetwTxtBlk_FormattedTextField.setHorizontalAlignment(11);
        this.UserVSpaceBetwTxtBlk_FormattedTextField.setFont(new Font("Tahoma 12", 0, 12));
        this.ScaleImage_Button.setFont(new Font("Tahoma", 0, 12));
        this.ScaleImage_Button.setText("Scale Image");
        this.ScaleImage_Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.ScaleImage_ButtonActionPerformed(evt);
            }
        });
        this.UserScaleFactor_jSpinner.setFont(new Font("Tahoma", 0, 12));
        this.UserScaleFactor_jSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.2f), Float.valueOf(8.0f), Float.valueOf(0.2f)));
        this.CallDigitize_jButton.setFont(new Font("Tahoma", 0, 18));
        this.CallDigitize_jButton.setText("Digitize Image");
        this.CallDigitize_jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.CallDigitize_jButtonActionPerformed(evt);
            }
        });
        this.UserWhiteStart_jSpinner.setFont(new Font("Tahoma", 0, 12));
        this.UserWhiteStart_jSpinner.setModel(new SpinnerNumberModel(180, 50, 240, 5));
        this.UserWhiteStart_jSpinner.setToolTipText("This pixel value and below will be WHITE");
        this.Binarize_Button.setFont(new Font("Tahoma", 0, 12));
        this.Binarize_Button.setText("Binarize");
        this.Binarize_Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.Binarize_ButtonActionPerformed(evt);
            }
        });
        GValue_jLabel.setFont(new Font("Arial", 0, 11));
        GValue_jLabel.setForeground(new Color(51, 51, 255));
        GValue_jLabel.setText("Grey Value at 1234,2334 is 251");
        GValue_jLabel.setPreferredSize(new Dimension(160, 14));
        GroupLayout ParamPanelLayout = new GroupLayout(this.ParamPanel);
        this.ParamPanel.setLayout(ParamPanelLayout);
        ParamPanelLayout.setHorizontalGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ParamPanelLayout.createSequentialGroup().addContainerGap().addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ParamPanelLayout.createSequentialGroup().addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ParamPanelLayout.createSequentialGroup().addComponent(this.UserLetterHeight_Button, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UserLetterHt_FormattedTextField, -2, 40, -2)).addGroup(ParamPanelLayout.createSequentialGroup().addComponent(this.UserHSpaceBetwTextBlk_Button, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UserHSpaceBetwTxtBlk_FormattedTextField, -2, -1, -2)).addGroup(ParamPanelLayout.createSequentialGroup().addComponent(this.UserVSpaceBetwTextBlk_Button, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UserVSpaceBetwTxtBlk_FormattedTextField, -2, -1, -2))).addContainerGap(22, Short.MAX_VALUE)).addGroup(ParamPanelLayout.createSequentialGroup().addComponent(this.CallDigitize_jButton, -2, 168, -2).addContainerGap(28, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, ParamPanelLayout.createSequentialGroup().addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(ParamPanelLayout.createSequentialGroup().addComponent(this.Binarize_Button, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.UserWhiteStart_jSpinner, -2, 42, -2)).addGroup(ParamPanelLayout.createSequentialGroup().addComponent(this.ScaleImage_Button, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.UserScaleFactor_jSpinner, -2, 42, -2))).addGap(20, 20, 20)).addGroup(ParamPanelLayout.createSequentialGroup().addComponent(GValue_jLabel, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)))));
        ParamPanelLayout.setVerticalGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ParamPanelLayout.createSequentialGroup().addContainerGap().addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.UserLetterHeight_Button, -2, 37, -2).addComponent(this.UserLetterHt_FormattedTextField, -2, 22, -2)).addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ParamPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.UserHSpaceBetwTextBlk_Button, -2, -1, -2).addGap(18, 18, 18).addComponent(this.UserVSpaceBetwTextBlk_Button, -2, -1, -2)).addGroup(ParamPanelLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.UserHSpaceBetwTxtBlk_FormattedTextField, -2, 22, -2).addGap(35, 35, 35).addComponent(this.UserVSpaceBetwTxtBlk_FormattedTextField, -2, 22, -2))).addGap(37, 37, 37).addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.UserScaleFactor_jSpinner, -2, -1, -2).addComponent(this.ScaleImage_Button, -2, 37, -2)).addGap(18, 18, 18).addGroup(ParamPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.UserWhiteStart_jSpinner, -2, -1, -2).addComponent(this.Binarize_Button, -2, 37, -2)).addGap(18, 18, 18).addComponent(GValue_jLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 180, Short.MAX_VALUE).addComponent(this.CallDigitize_jButton, -2, 37, -2).addGap(29, 29, 29)));
        this.getContentPane().add((Component)this.ParamPanel, "Center");
        this.File_jMenu.setText("File");
        this.OpenImageDoc_jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.OpenImageDoc_jMenuItem.setText("Open Image Document");
        this.OpenImageDoc_jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.OpenImageDoc_jMenuItemActionPerformed(evt);
            }
        });
        this.File_jMenu.add(this.OpenImageDoc_jMenuItem);
        this.Exit_jMenuItem.setText("Exit");
        this.Exit_jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.Exit_jMenuItemActionPerformed(evt);
            }
        });
        this.File_jMenu.add(this.Exit_jMenuItem);
        this.ocrguiMenuBar.add(this.File_jMenu);
        this.Options_jMenu.setText("Options");
        this.jParams.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jParams.setText("Parameters");
        this.jParams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ocrgui.this.jParamsActionPerformed(evt);
            }
        });
        this.Options_jMenu.add(this.jParams);
        this.ocrguiMenuBar.add(this.Options_jMenu);
        this.setJMenuBar(this.ocrguiMenuBar);
        this.pack();
    }

    private void ScaleImage_ButtonActionPerformed(ActionEvent evt) {
        float sfactor;
        this.SFactor = sfactor = Float.valueOf(this.UserScaleFactor_jSpinner.getValue().toString()).floatValue();
        if (this.prev_factor == sfactor && !this.force_scale) {
            return;
        }
        this.di_pane.scaleDocImage(sfactor);
        this.di_pane.setScaleFactor(sfactor);
        this.prev_factor = sfactor;
        this.force_scale = false;
        GValue_jLabel.setVisible(false);
    }

    private void UserLetterHeight_ButtonActionPerformed(ActionEvent evt) {
        this.UserLetterHt_FormattedTextField.setValue((int)((float)this.di_pane.getUserLetterheight() / this.SFactor));
    }

    private void UserHSpaceBetwTextBlk_ButtonActionPerformed(ActionEvent evt) {
        this.UserHSpaceBetwTxtBlk_FormattedTextField.setValue((int)((float)this.di_pane.getUserHSpaceBetwTextBlk() / this.SFactor));
    }

    private void UserVSpaceBetwTextBlk_ButtonActionPerformed(ActionEvent evt) {
        this.UserVSpaceBetwTxtBlk_FormattedTextField.setValue((int)((float)this.di_pane.getUserVSpaceBetwTextBlk() / this.SFactor));
    }

    private void Exit_jMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void OpenImageDoc_jMenuItemActionPerformed(ActionEvent evt) {
        this.Image_jFileChooser.setCurrentDirectory(new File(this.image_folder));
        int returnVal = this.Image_jFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            GValue_jLabel.setVisible(false);
            File file = this.Image_jFileChooser.getSelectedFile();
            this.ImageFile = file.getName();
            this.ImageFilePath = file.getAbsolutePath();
            System.out.println("Opening: " + this.ImageFilePath + " ...");
            this.di_pane.openImageFile(this.ImageFilePath);
            this.SFactor = 1.0f;
            this.prev_factor = 1.0f;
            this.UserScaleFactor_jSpinner.setValue(1.0);
            this.di_pane.setScaleFactor(this.SFactor);
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    private void CallDigitize_jButtonActionPerformed(ActionEvent evt) {
        this.invokeOCRServer();
    }

    private void Binarize_ButtonActionPerformed(ActionEvent evt) {
        GValue_jLabel.setVisible(false);
        this.di_pane.binarizeImage(Integer.parseInt(this.UserWhiteStart_jSpinner.getValue().toString()), this.SFactor);
        this.force_scale = true;
    }

    private void jParamsActionPerformed(ActionEvent evt) {
        this.Config_jFrame.setLocationRelativeTo(null);
        this.Config_jFrame.setVisible(true);
        this.Config_jFrame.requestFocus();
    }

    private void Config_jFrameWindowDeactivated(WindowEvent evt) {
        if (!this.image_folder.equals(this.image_folder_jTextField.getText())) {
            this.image_folder = this.image_folder_jTextField.getText();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.LogPS != null) {
            this.LogPS.close();
        }
        this.SaveConfigFile();
    }

    public static void main(String[] args) {
        if (!ApplicationInstanceManager.registerInstance()) {
            JOptionPane.showMessageDialog(null, "Another instance of this application is already running.  Exiting.", "Multiple Instance Error", 0);
            System.exit(0);
        }
        ApplicationInstanceManager.setApplicationInstanceListener(new ApplicationInstanceListener(){

            public void newInstanceCreated() {
            }
        });
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ocrgui.createAndShowGUI();
            }
        });
    }

    static {
        PREF_BODY_HEIGHT = 13;
        OCRClientReqTimeOut = 60000;
    }
}

