/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import ocr.ApplicationInstanceListener;

public class ApplicationInstanceManager {
    private static ApplicationInstanceListener subListener;
    public static final int SINGLE_INSTANCE_NETWORK_SOCKET = 36457;
    public static final String SINGLE_INSTANCE_SHARED_KEY = "$$NewInstance$$\n";

    public static boolean registerInstance() {
        boolean returnValueOnError = true;
        try {
            final ServerSocket socket = new ServerSocket(36457, 10, InetAddress.getLocalHost());
            Thread instanceListenerThread = new Thread(new Runnable(){

                public void run() {
                    boolean socketClosed = false;
                    while (!socketClosed) {
                        if (socket.isClosed()) {
                            socketClosed = true;
                            continue;
                        }
                        try {
                            Socket client = socket.accept();
                            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                            String message = in.readLine();
                            if (ApplicationInstanceManager.SINGLE_INSTANCE_SHARED_KEY.trim().equals(message.trim())) {
                                ApplicationInstanceManager.fireNewInstance();
                            }
                            in.close();
                            client.close();
                        }
                        catch (IOException e) {
                            socketClosed = true;
                        }
                    }
                }
            });
            instanceListenerThread.start();
        }
        catch (UnknownHostException e) {
            return returnValueOnError;
        }
        catch (IOException e) {
            try {
                Socket clientSocket = new Socket(InetAddress.getLocalHost(), 36457);
                OutputStream out = clientSocket.getOutputStream();
                out.write(SINGLE_INSTANCE_SHARED_KEY.getBytes());
                out.close();
                clientSocket.close();
                return false;
            }
            catch (UnknownHostException e1) {
                return returnValueOnError;
            }
            catch (IOException e1) {
                return returnValueOnError;
            }
        }
        return true;
    }

    public static void setApplicationInstanceListener(ApplicationInstanceListener listener) {
        subListener = listener;
    }

    private static void fireNewInstance() {
        if (subListener != null) {
            subListener.newInstanceCreated();
        }
    }
}

