/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Component;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import ocr.AccessibleUtils$AccessibleException;
import ocr.AccessibleUtils$AccessibleValues;

public class AccessibleUtils {
    protected static final Class[] _sType = new Class[]{String.class};
    protected static final Class[] _iType = new Class[]{Integer.TYPE};

    public static String resolveString(ResourceBundle resourceBundle, String string) {
        String string2;
        return resourceBundle != null ? ((string2 = resourceBundle.getString(string)) != null ? string2 : string) : string;
    }

    public static Method resolveMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    public static Method resolveMethod(Class clazz, String string) {
        return AccessibleUtils.resolveMethod(clazz, string, null);
    }

    public static Method resolveMethod(Object object, String string, Class[] classArray) {
        return AccessibleUtils.resolveMethod(object.getClass(), string, classArray);
    }

    public static Method resolveMethod(Object object, String string) {
        return AccessibleUtils.resolveMethod(object.getClass(), string, null);
    }

    public static Object invokeMethod(Object object, Method method, Object[] objectArray) {
        return method.invoke(object, objectArray);
    }

    public static Object invokeMethod(Object object, Method method) {
        return AccessibleUtils.invokeMethod(object, method, null);
    }

    public static Accessible setAccessibleValues(ResourceBundle resourceBundle, Accessible accessible, AccessibleUtils$AccessibleValues accessibleUtils$AccessibleValues) {
        Object object;
        if (accessibleUtils$AccessibleValues.name != null) {
            if (accessible instanceof Component) {
                ((Component)((Object)accessible)).setName(accessibleUtils$AccessibleValues.name);
            }
        } else {
            throw new NullPointerException("accessible components require a name");
        }
        if (accessibleUtils$AccessibleValues.text != null) {
            object = AccessibleUtils.resolveMethod(accessible, "setText", _sType);
            if (object != null) {
                try {
                    AccessibleUtils.invokeMethod(accessible, (Method)object, new String[]{AccessibleUtils.resolveString(resourceBundle, accessibleUtils$AccessibleValues.text)});
                }
                catch (Exception exception) {
                    throw new AccessibleUtils$AccessibleException("cannot invoke method setText(String text) - " + accessible, exception);
                }
            } else {
                throw new AccessibleUtils$AccessibleException("cannot find method setText(String text) - " + accessible);
            }
        }
        if (accessibleUtils$AccessibleValues.borderText != null) {
            object = (JComponent)((Object)accessible);
            Border border = ((JComponent)object).getBorder();
            TitledBorder titledBorder = new TitledBorder(AccessibleUtils.resolveString(resourceBundle, accessibleUtils$AccessibleValues.borderText));
            ((JComponent)object).setBorder(border != null ? new CompoundBorder(border, titledBorder) : titledBorder);
        }
        if (accessibleUtils$AccessibleValues.toolTip != null) {
            object = AccessibleUtils.resolveString(resourceBundle, accessibleUtils$AccessibleValues.toolTip.equalsIgnoreCase("=ld") ? accessibleUtils$AccessibleValues.longDescription : accessibleUtils$AccessibleValues.toolTip);
            if (accessible instanceof JComponent) {
                ((JComponent)((Object)accessible)).setToolTipText((String)object);
            } else if (accessible instanceof ImageIcon) {
                ((ImageIcon)accessible).setDescription((String)object);
            }
        }
        if (accessibleUtils$AccessibleValues.mnemonic >= 0) {
            object = AccessibleUtils.resolveMethod(accessible, "setMnemonic", _iType);
            if (object == null) {
                object = AccessibleUtils.resolveMethod(accessible, "setDisplayedMnemonic", _iType);
            }
            if (object != null) {
                try {
                    AccessibleUtils.invokeMethod(accessible, (Method)object, new Integer[]{new Integer(accessibleUtils$AccessibleValues.mnemonic)});
                }
                catch (Exception exception) {
                    throw new AccessibleUtils$AccessibleException("cannot invoke method set{Displayed}Mnemonic(int key) - " + accessible, exception);
                }
            } else {
                throw new AccessibleUtils$AccessibleException("cannot find method set{Displayed}Mnemonic(int key) - " + accessible);
            }
        }
        if (accessibleUtils$AccessibleValues.shortDescription == null) {
            throw new NullPointerException("accessible components require a shortDescription");
        }
        if (accessibleUtils$AccessibleValues.shortDescription.equalsIgnoreCase("=tt")) {
            accessibleUtils$AccessibleValues.shortDescription = accessibleUtils$AccessibleValues.toolTip;
        }
        if (accessibleUtils$AccessibleValues.shortDescription.equalsIgnoreCase("=ld")) {
            accessibleUtils$AccessibleValues.shortDescription = accessibleUtils$AccessibleValues.longDescription;
        }
        if (accessibleUtils$AccessibleValues.shortDescription.length() == 0) {
            accessibleUtils$AccessibleValues.shortDescription = null;
        }
        if (accessibleUtils$AccessibleValues.shortDescription != null && accessible instanceof ImageIcon) {
            ((ImageIcon)accessible).setDescription(AccessibleUtils.resolveString(resourceBundle, accessibleUtils$AccessibleValues.shortDescription));
        }
        if ((object = accessible.getAccessibleContext()) == null) {
            throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + AccessibleUtils.formatClassToken(accessible));
        }
        if (accessibleUtils$AccessibleValues.shortDescription != null) {
            ((AccessibleContext)object).setAccessibleName(AccessibleUtils.resolveString(resourceBundle, accessibleUtils$AccessibleValues.shortDescription));
        }
        if (accessibleUtils$AccessibleValues.longDescription != null) {
            ((AccessibleContext)object).setAccessibleDescription(AccessibleUtils.resolveString(resourceBundle, accessibleUtils$AccessibleValues.longDescription.equalsIgnoreCase("=tt") ? accessibleUtils$AccessibleValues.toolTip : accessibleUtils$AccessibleValues.longDescription));
        }
        return accessible;
    }

    public static Accessible setLabelRelationship(Accessible accessible, Accessible accessible2) {
        if (accessible instanceof JLabel) {
            ((JLabel)accessible).setLabelFor((Component)((Object)accessible2));
            AccessibleContext accessibleContext = accessible2.getAccessibleContext();
            if (accessibleContext == null) {
                throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + AccessibleUtils.formatClassToken(accessible2));
            }
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.LABELED_BY, accessible);
            accessibleRelationSet.add(accessibleRelation);
        }
        return accessible;
    }

    public static Accessible setMemberRelationship(Accessible accessible, Accessible accessible2) {
        return AccessibleUtils.setMemberRelationship(accessible, new Accessible[]{accessible2});
    }

    public static Accessible setMemberRelationship(Accessible accessible, Accessible[] accessibleArray) {
        return AccessibleUtils.setMemberRelationship(accessible, Arrays.asList(accessibleArray));
    }

    public static Accessible setMemberRelationship(Accessible accessible, Collection collection) {
        for (Accessible accessible2 : collection) {
            AccessibleContext accessibleContext = accessible2.getAccessibleContext();
            if (accessibleContext == null) {
                throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + AccessibleUtils.formatClassToken(accessible2));
            }
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.MEMBER_OF, accessible);
            accessibleRelationSet.add(accessibleRelation);
        }
        return accessible;
    }

    public static Object normalize(Object object) {
        if (object != null && object instanceof String) {
            String string = (String)object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            for (int j = 0; j < string.length(); ++j) {
                char c2 = string.charAt(j);
                if (c2 == '\"' || c2 == '\'') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
            stringBuffer.append('\"');
        }
        return object;
    }

    public static String formatClassToken(Object object) {
        if (object == null) {
            return "null";
        }
        String string = object instanceof Component ? ((Component)object).getName() : "?";
        return object.getClass().getName() + ":" + Integer.toHexString(object.hashCode()).toUpperCase() + "-" + string;
    }

    public static String getDefaultFormatDelimiters() {
        return ";";
    }

    public static String formatText(String string, Object[] objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    public static String formatText(String string, String string2) {
        return AccessibleUtils.formatText(string, string2, AccessibleUtils.getDefaultFormatDelimiters());
    }

    public static String formatText(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        Object[] objectArray = new Object[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return AccessibleUtils.formatText(string, objectArray);
    }

    public static String formatText(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormat.format(AccessibleUtils.resolveString(resourceBundle, string), objectArray);
    }

    public static String formatText(ResourceBundle resourceBundle, String string, String string2) {
        return AccessibleUtils.formatText(resourceBundle, string, string2, AccessibleUtils.getDefaultFormatDelimiters());
    }

    public static String formatText(ResourceBundle resourceBundle, String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        Object[] objectArray = new Object[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return AccessibleUtils.formatText(resourceBundle, string, objectArray);
    }
}

