/*
 * Decompiled with CFR 0.152.
 */
package ngpkg;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TernarySearchTree {
    private TSTNode rootNode;
    private int defaultNumReturnValues = -1;
    private int lastNumberOfReturnValues;
    private List sortKeysResult;
    private List<String> _sortKeysResult;
    private boolean sortKeysList;
    private StringBuffer sortKeysBuffer;
    private int sortKeysNumReturnValues;
    private List matchAlmostResult;
    private StringBuffer matchAlmostBuffer;
    private boolean matchAlmostListAction;
    private int matchAlmostNumReturnValues;
    private String matchAlmostKey;
    private int matchAlmostDiff;
    private int maxMatchAlmostDiff = 4;
    private StringBuffer getKeyBuffer = new StringBuffer();
    private int numNodes;
    private boolean checkData;

    public void put(String key, Object value) {
        this.getOrCreateNode((String)key).data = value;
    }

    public Object get(String key) {
        TSTNode node = this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    public void remove(String key) {
        this.deleteNode(this.getNode(key));
    }

    public void setNumReturnValues(int num) {
        this.defaultNumReturnValues = num < 0 ? -1 : num;
    }

    private int checkNumberOfReturnValues(int numReturnValues) {
        return numReturnValues < 0 ? -1 : numReturnValues;
    }

    public int getLastNumReturnValues() {
        return this.lastNumberOfReturnValues;
    }

    public TSTNode getNode(String key) {
        return this.getNode(key, this.rootNode);
    }

    protected TSTNode getNode(String key, TSTNode startNode) {
        if (key == null || startNode == null || key.length() == 0) {
            return null;
        }
        TSTNode currentNode = startNode;
        int charIndex = 0;
        while (currentNode != null) {
            int charComp = TernarySearchTree.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar);
            if (charComp == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                currentNode = currentNode.relatives[1];
                continue;
            }
            currentNode = currentNode.relatives[3];
        }
        return null;
    }

    public List matchPrefix(String prefix) {
        return this.matchPrefix(prefix, this.defaultNumReturnValues);
    }

    public List<String> _matchPrefix(String prefix) {
        return this._matchPrefix(prefix, this.defaultNumReturnValues);
    }

    public List matchPrefix(String prefix, int numReturnValues) {
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.sortKeysResult = new ArrayList();
        TSTNode startNode = this.getNode(prefix);
        if (startNode == null) {
            return this.sortKeysResult;
        }
        if (startNode.data != null) {
            this.sortKeysResult.add(this.getKey(startNode));
            --this.sortKeysNumReturnValues;
        }
        this.sortKeysList = true;
        this.sortKeysRecursion(startNode.relatives[2]);
        return this.sortKeysResult;
    }

    public List<String> _matchPrefix(String prefix, int numReturnValues) {
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this._sortKeysResult = new ArrayList<String>();
        TSTNode startNode = this.getNode(prefix);
        if (startNode == null) {
            return this._sortKeysResult;
        }
        if (startNode.data != null) {
            this._sortKeysResult.add(this.getKey(startNode));
            --this.sortKeysNumReturnValues;
        }
        this.sortKeysList = true;
        this._sortKeysRecursion(startNode.relatives[2]);
        return this._sortKeysResult;
    }

    public String matchPrefixString(String prefix) {
        return this.matchPrefixString(prefix, this.defaultNumReturnValues);
    }

    public String matchPrefixString(String prefix, int numReturnValues) {
        TSTNode startNode = this.getNode(prefix);
        if (startNode == null) {
            return "";
        }
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.lastNumberOfReturnValues = this.sortKeysNumReturnValues--;
        this.sortKeysBuffer = new StringBuffer();
        if (startNode.data != null) {
            this.sortKeysBuffer.append(this.getKey(startNode) + "\n");
        }
        this.sortKeysList = false;
        this.sortKeysRecursion(startNode.relatives[2]);
        int bufferLength = this.sortKeysBuffer.length();
        if (bufferLength > 0) {
            this.sortKeysBuffer.setLength(bufferLength - 1);
        }
        this.lastNumberOfReturnValues -= this.sortKeysNumReturnValues;
        return this.sortKeysBuffer.toString();
    }

    private void sortKeysRecursion(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        this.sortKeysRecursion(currentNode.relatives[1]);
        if (this.sortKeysNumReturnValues == 0) {
            return;
        }
        if (currentNode.data != null) {
            if (this.sortKeysList) {
                this.sortKeysResult.add(this.getKey(currentNode));
            } else {
                this.sortKeysBuffer.append(this.getKey(currentNode) + "\n");
            }
            --this.sortKeysNumReturnValues;
        }
        this.sortKeysRecursion(currentNode.relatives[2]);
        this.sortKeysRecursion(currentNode.relatives[3]);
    }

    private void _sortKeysRecursion(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        this._sortKeysRecursion(currentNode.relatives[1]);
        if (this.sortKeysNumReturnValues == 0) {
            return;
        }
        if (currentNode.data != null) {
            if (this.sortKeysList) {
                this._sortKeysResult.add(this.getKey(currentNode));
            } else {
                this.sortKeysBuffer.append(this.getKey(currentNode) + "\n");
            }
            --this.sortKeysNumReturnValues;
        }
        this._sortKeysRecursion(currentNode.relatives[2]);
        this._sortKeysRecursion(currentNode.relatives[3]);
    }

    protected List sortKeys(TSTNode startNode, int numReturnValues) {
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.sortKeysResult = new ArrayList();
        this.sortKeysRecursion(startNode);
        return this.sortKeysResult;
    }

    protected List<String> _sortKeys(TSTNode startNode, int numReturnValues) {
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this._sortKeysResult = new ArrayList<String>();
        this._sortKeysRecursion(startNode);
        return this._sortKeysResult;
    }

    public String sortKeysString(int numReturnValues) {
        return this.sortKeysString(this.rootNode, numReturnValues);
    }

    public String sortKeysString() {
        return this.sortKeysString(this.rootNode, this.defaultNumReturnValues);
    }

    public String sortKeysString(TSTNode startNode, int numReturnValues) {
        if (startNode == null) {
            return new String("");
        }
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.lastNumberOfReturnValues = this.sortKeysNumReturnValues--;
        this.sortKeysBuffer = new StringBuffer();
        if (startNode.data != null) {
            this.sortKeysBuffer.append(this.getKey(startNode) + "\n");
        }
        this.sortKeysList = false;
        this.sortKeysRecursion(startNode);
        int bufferLength = this.sortKeysBuffer.length();
        if (bufferLength > 0) {
            this.sortKeysBuffer.setLength(bufferLength - 1);
        }
        this.lastNumberOfReturnValues -= this.sortKeysNumReturnValues;
        return this.sortKeysBuffer.toString();
    }

    public List matchAlmost(String key) {
        return this.matchAlmost(key, this.defaultNumReturnValues);
    }

    protected List matchAlmost(String key, int numReturnValues) {
        this.matchAlmostListAction = true;
        this.matchAlmostNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.matchAlmostResult = new ArrayList();
        this.matchAlmostKey = key;
        this.matchAlmostRecursion(this.rootNode, 0, this.matchAlmostDiff);
        return this.matchAlmostResult;
    }

    public String matchAlmostString(String key) {
        return this.matchAlmostString(key, this.defaultNumReturnValues);
    }

    protected String matchAlmostString(String key, int numReturnValues) {
        this.matchAlmostListAction = false;
        this.lastNumberOfReturnValues = this.matchAlmostNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.matchAlmostBuffer = new StringBuffer();
        this.matchAlmostKey = key;
        this.matchAlmostRecursion(this.rootNode, 0, this.matchAlmostDiff);
        int bufferLength = this.matchAlmostBuffer.length();
        if (bufferLength > 0) {
            this.matchAlmostBuffer.setLength(bufferLength - 1);
        }
        this.lastNumberOfReturnValues -= this.matchAlmostNumReturnValues;
        return this.matchAlmostBuffer.toString();
    }

    private void matchAlmostRecursion(TSTNode currentNode, int charIndex, int d) {
        int nextD;
        if (currentNode == null || d < 0 || this.matchAlmostNumReturnValues == 0 || charIndex >= this.matchAlmostKey.length()) {
            return;
        }
        int charComp = TernarySearchTree.compareCharsAlphabetically(this.matchAlmostKey.charAt(charIndex), currentNode.splitchar);
        if (d > 0 || charComp < 0) {
            this.matchAlmostRecursion(currentNode.relatives[1], charIndex, d);
        }
        int n = nextD = charComp == 0 ? d : d - 1;
        if (this.matchAlmostKey.length() == charIndex + 1 && nextD == 0 && currentNode.data != null) {
            if (this.matchAlmostListAction) {
                this.matchAlmostResult.add(this.getKey(currentNode));
            } else {
                this.matchAlmostBuffer.append(this.getKey(currentNode) + "\n");
            }
            --this.matchAlmostNumReturnValues;
        }
        this.matchAlmostRecursion(currentNode.relatives[2], charIndex + 1, nextD);
        if (d > 0 || charComp > 0) {
            this.matchAlmostRecursion(currentNode.relatives[3], charIndex, d);
        }
    }

    public void setMatchAlmostDiff(int diff) {
        this.matchAlmostDiff = diff < 0 ? 0 : (diff > this.maxMatchAlmostDiff ? this.maxMatchAlmostDiff : diff);
    }

    protected TSTNode getOrCreateNode(String key) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("attempt to get or create node with null key");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("attempt to get or create node with key of zero length");
        }
        if (this.rootNode == null) {
            this.rootNode = new TSTNode(key.charAt(0), null);
        }
        TSTNode currentNode = this.rootNode;
        int charIndex = 0;
        while (true) {
            int charComp;
            if ((charComp = TernarySearchTree.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar)) == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                if (currentNode.relatives[2] == null) {
                    currentNode.relatives[2] = new TSTNode(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                if (currentNode.relatives[1] == null) {
                    currentNode.relatives[1] = new TSTNode(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[1];
                continue;
            }
            if (currentNode.relatives[3] == null) {
                currentNode.relatives[3] = new TSTNode(key.charAt(charIndex), currentNode);
            }
            currentNode = currentNode.relatives[3];
        }
    }

    private void deleteNode(TSTNode nodeToDelete) {
        if (nodeToDelete == null) {
            return;
        }
        nodeToDelete.data = null;
        while (nodeToDelete != null) {
            nodeToDelete = this.deleteNodeRecursion(nodeToDelete);
        }
    }

    private TSTNode deleteNodeRecursion(TSTNode currentNode) {
        TSTNode targetNode;
        int movingKid;
        int childType;
        boolean hikidNull;
        if (currentNode == null) {
            return null;
        }
        if (currentNode.relatives[2] != null || currentNode.data != null) {
            return null;
        }
        TSTNode currentParent = currentNode.relatives[0];
        boolean lokidNull = currentNode.relatives[1] == null;
        boolean bl = hikidNull = currentNode.relatives[3] == null;
        if (currentParent.relatives[1] == currentNode) {
            childType = 1;
        } else if (currentParent.relatives[2] == currentNode) {
            childType = 2;
        } else if (currentParent.relatives[3] == currentNode) {
            childType = 3;
        } else {
            this.rootNode = null;
            return null;
        }
        if (lokidNull && hikidNull) {
            currentParent.relatives[childType] = null;
            return currentParent;
        }
        if (lokidNull) {
            currentParent.relatives[childType] = currentNode.relatives[3];
            currentNode.relatives[3].relatives[0] = currentParent;
            return currentParent;
        }
        if (hikidNull) {
            currentParent.relatives[childType] = currentNode.relatives[1];
            currentNode.relatives[1].relatives[0] = currentParent;
            return currentParent;
        }
        int deltaHi = currentNode.relatives[3].splitchar - currentNode.splitchar;
        int deltaLo = currentNode.splitchar - currentNode.relatives[1].splitchar;
        if (deltaHi == deltaLo) {
            if (Math.random() < 0.5) {
                ++deltaHi;
            } else {
                ++deltaLo;
            }
        }
        if (deltaHi > deltaLo) {
            movingKid = 3;
            targetNode = currentNode.relatives[1];
        } else {
            movingKid = 1;
            targetNode = currentNode.relatives[3];
        }
        while (targetNode.relatives[movingKid] != null) {
            targetNode = targetNode.relatives[movingKid];
        }
        targetNode.relatives[movingKid] = currentNode.relatives[movingKid];
        currentParent.relatives[childType] = targetNode;
        targetNode.relatives[0] = currentParent;
        if (!lokidNull) {
            currentNode.relatives[1] = null;
        }
        if (!hikidNull) {
            currentNode.relatives[3] = null;
        }
        return currentParent;
    }

    protected String getKey(TSTNode node) {
        this.getKeyBuffer.setLength(0);
        this.getKeyBuffer.append(node.splitchar);
        TSTNode currentNode = node.relatives[0];
        TSTNode lastNode = node;
        while (currentNode != null) {
            if (currentNode.relatives[2] == lastNode) {
                this.getKeyBuffer.append(currentNode.splitchar);
            }
            lastNode = currentNode;
            currentNode = currentNode.relatives[0];
        }
        this.getKeyBuffer.reverse();
        return this.getKeyBuffer.toString();
    }

    public int numNodes() {
        return this.numNodes(this.rootNode);
    }

    protected int numNodes(TSTNode startingNode) {
        this.numNodes = 0;
        this.checkData = false;
        this.recursiveNodeCalculator(startingNode);
        return this.numNodes;
    }

    public int numDataNodes() {
        return this.numDataNodes(this.rootNode);
    }

    protected int numDataNodes(TSTNode startingNode) {
        this.numNodes = 0;
        this.checkData = true;
        this.recursiveNodeCalculator(startingNode);
        return this.numNodes;
    }

    private void recursiveNodeCalculator(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        this.recursiveNodeCalculator(currentNode.relatives[1]);
        this.recursiveNodeCalculator(currentNode.relatives[2]);
        this.recursiveNodeCalculator(currentNode.relatives[3]);
        if (this.checkData) {
            if (currentNode.data != null) {
                ++this.numNodes;
            }
        } else {
            ++this.numNodes;
        }
    }

    protected void printTree() {
        System.out.println("");
        if (this.rootNode == null) {
            System.out.println("tree is empty");
            return;
        }
        System.out.println("Here's the entire tree structure:");
        this.printNodeRecursion(this.rootNode);
    }

    protected void printTree(TSTNode startingNode) {
        System.out.println("");
        if (this.rootNode == null) {
            System.out.println("subtree is empty");
            return;
        }
        System.out.println("Here's the entire subtree structure:");
        this.printNodeRecursion(startingNode);
    }

    private void printNodeRecursion(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        System.out.println("");
        System.out.println("( keys are delimited by vertical lines: |example key| )");
        System.out.println("info for node   |" + this.getKey(currentNode) + "|         node data: " + currentNode.data);
        if (currentNode.relatives[0] == null) {
            System.out.println("parent null");
        } else {
            System.out.println("parent key   |" + this.getKey(currentNode.relatives[0]) + "|       parent data: " + currentNode.relatives[0].data);
        }
        if (currentNode.relatives[1] == null) {
            System.out.println("lokid null");
        } else {
            System.out.println("lokid key   |" + this.getKey(currentNode.relatives[1]) + "|       lo kid data: " + currentNode.relatives[1].data);
        }
        if (currentNode.relatives[2] == null) {
            System.out.println("eqkid null");
        } else {
            System.out.println("eqkid key   |" + this.getKey(currentNode.relatives[2]) + "|       equal kid data: " + currentNode.relatives[2].data);
        }
        if (currentNode.relatives[3] == null) {
            System.out.println("hikid null");
        } else {
            System.out.println("hikid key   |" + this.getKey(currentNode.relatives[3]) + "|       hi kid data: " + currentNode.relatives[3].data);
        }
        this.printNodeRecursion(currentNode.relatives[1]);
        this.printNodeRecursion(currentNode.relatives[2]);
        this.printNodeRecursion(currentNode.relatives[3]);
    }

    public static int compareCharsAlphabetically(char cCompare, char cRef) {
        return TernarySearchTree.alphabetizeChar(cCompare) - TernarySearchTree.alphabetizeChar(cRef);
    }

    private static int alphabetizeChar(char c) {
        if (c < 'A') {
            return c;
        }
        if (c < 'Y') {
            return 2 * c - 65;
        }
        if (c < 'a') {
            return c + 24;
        }
        if (c < 'y') {
            return 2 * c - 128;
        }
        return c;
    }

    protected class TSTNode {
        protected static final int PARENT = 0;
        protected static final int LOKID = 1;
        protected static final int EQKID = 2;
        protected static final int HIKID = 3;
        protected char splitchar;
        protected TSTNode[] relatives = new TSTNode[4];
        protected Object data;

        protected TSTNode(char splitchar, TSTNode parent) {
            this.splitchar = splitchar;
            this.relatives[0] = parent;
        }
    }
}

