/*
 * Decompiled with CFR 0.152.
 */
package ngpkg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import ngpkg.ktranslit;

public class MainWin
extends JFrame {
    Map<String, String> EngKanDict;
    ktranslit KTr;
    boolean DictionaryModified = false;
    boolean InKanTexBox = false;
    boolean CtrlKeyPressed = false;
    final Clipboard clipboard = this.getToolkit().getSystemClipboard();
    String matched_words;
    boolean readme_ALT_key_pressed = false;
    private JLabel Cright_jLabel;
    private JTextField EngWord;
    private JLabel EngWordLabel;
    private JScrollPane KanWords_jScrollPane;
    private JTextArea KanWords_jTextArea;
    private JLabel KannadaWordLabel;
    private JMenuItem MainWinFile_Exit_jMenuItem;
    private JMenuItem MainWinFile_Readme_jMenuItem;
    private JMenu MainWinFile_jMenu;
    private JMenuBar MainWin_jMenuBar;
    private JLabel Message_jLabel;
    private JInternalFrame ReadMeFrame;
    private JScrollPane ReadMeScrollPane;
    private JTextArea ReadMeTextArea;

    public MainWin() {
        this.EngKanDict = new HashMap<String, String>();
        this.initComponents();
        Toolkit tk = Toolkit.getDefaultToolkit();
        int pixels_per_inch = tk.getScreenResolution();
        Dimension ScreenSize = tk.getScreenSize();
        this.setSize(640, 480);
        this.setLocation((ScreenSize.width - 640) / 2, (ScreenSize.height - 480) / 2);
        if (!this.LoadDictionary()) {
            System.out.println("Error: Cannot read dictionary file. Terminating...");
            System.exit(0);
        }
        this.MainWinFile_jMenu.setMnemonic(70);
        this.MainWinFile_Readme_jMenuItem.setMnemonic(82);
        this.MainWinFile_Exit_jMenuItem.setMnemonic(88);
        this.KTr = new ktranslit();
        this.EngWord.setText("type a word");
        this.EngWord.selectAll();
    }

    private void initComponents() {
        this.EngWordLabel = new JLabel();
        this.EngWord = new JTextField();
        this.KannadaWordLabel = new JLabel();
        this.KanWords_jScrollPane = new JScrollPane();
        this.KanWords_jTextArea = new JTextArea();
        this.Cright_jLabel = new JLabel();
        this.ReadMeFrame = new JInternalFrame();
        this.ReadMeScrollPane = new JScrollPane();
        this.ReadMeTextArea = new JTextArea();
        this.Message_jLabel = new JLabel();
        this.MainWin_jMenuBar = new JMenuBar();
        this.MainWinFile_jMenu = new JMenu();
        this.MainWinFile_Readme_jMenuItem = new JMenuItem();
        this.MainWinFile_Exit_jMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Kanigha v1.1 (English - Kannada Dictionary)");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainWin.this.formWindowClosing(evt);
            }
        });
        this.EngWordLabel.setFont(new Font("Tahoma", 0, 14));
        this.EngWordLabel.setForeground(Color.blue);
        this.EngWordLabel.setText("Type a word to lookup:");
        this.EngWord.setFont(new Font("Tahoma", 0, 18));
        this.EngWord.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                MainWin.this.EngWordFocusGained(evt);
            }
        });
        this.EngWord.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainWin.this.EngWordKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                MainWin.this.EngWordKeyReleased(evt);
            }
        });
        this.KannadaWordLabel.setFont(new Font("Tahoma", 0, 14));
        this.KannadaWordLabel.setForeground(Color.blue);
        this.KannadaWordLabel.setText("Equivalent Kannada Word(s):");
        this.KanWords_jScrollPane.setHorizontalScrollBarPolicy(31);
        this.KanWords_jScrollPane.setVerticalScrollBarPolicy(21);
        this.KanWords_jTextArea.setBackground(SystemColor.menu);
        this.KanWords_jTextArea.setColumns(20);
        this.KanWords_jTextArea.setFont(new Font("Arial Unicode MS", 0, 18));
        this.KanWords_jTextArea.setLineWrap(true);
        this.KanWords_jTextArea.setRows(5);
        this.KanWords_jTextArea.setWrapStyleWord(true);
        this.KanWords_jTextArea.setAutoscrolls(false);
        this.KanWords_jTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.KanWords_jTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                MainWin.this.KanWords_jTextAreaFocusGained(evt);
            }
        });
        this.KanWords_jTextArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainWin.this.KanWords_jTextAreaKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                MainWin.this.KanWords_jTextAreaKeyReleased(evt);
            }
        });
        this.KanWords_jScrollPane.setViewportView(this.KanWords_jTextArea);
        this.Cright_jLabel.setText("(c) 2012 Prakash B V       All rights reserved.");
        this.ReadMeFrame.setBorder(new LineBorder(new Color(255, 255, 102), 2, true));
        this.ReadMeFrame.setClosable(true);
        this.ReadMeFrame.setTitle("Read Me");
        this.ReadMeFrame.setAlignmentX(20.0f);
        this.ReadMeFrame.setAlignmentY(20.0f);
        this.ReadMeFrame.setAutoscrolls(true);
        this.ReadMeFrame.setMinimumSize(new Dimension(400, 400));
        this.ReadMeFrame.setOpaque(true);
        this.ReadMeFrame.setPreferredSize(new Dimension(400, 300));
        try {
            this.ReadMeFrame.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.ReadMeScrollPane.setVerticalScrollBarPolicy(22);
        this.ReadMeTextArea.setColumns(20);
        this.ReadMeTextArea.setEditable(false);
        this.ReadMeTextArea.setFont(new Font("Arial", 0, 12));
        this.ReadMeTextArea.setLineWrap(true);
        this.ReadMeTextArea.setRows(5);
        this.ReadMeTextArea.setTabSize(4);
        this.ReadMeTextArea.setText("LICENSE:\n\n'Kanigha' is an English to Kannada dictionary. There were requests from users of KanScan to develop and make avaiable a dictionary software application that could be maintained by the user. The user should be able to \n(a) lookup Kannada equivalent words for English word that is entered.\n(b) add English word and its Kannada equivalent word to the dictionary\n(c) to type Kannada equivalent word using English letters, as in google transliteration. \n\n'Kanigha' version 1.1\" is shareware. This software is free for personal use only.\nNote that the  application does not come with dictionary data. Only a dictionary data template file is provided. It is up to the users to update the dictionary file. \nProvision will be made for users to upload dictionary data file to kannadaocr.com. Periodically, alll these files will be synched up and a master dictinary will be made available for people to use.\n\nNO PART OF 'Kanigha'' MAY BE TRANSFERRED, LICENSED, SOLD, REDISTRIBUTED OR REPRODUCED WITHOUT THE EXPRESS WRITTEN CONSENT OF PRAKASH B. V.  This includes (but is\nnot limited to) CD-ROM distributions, uploading the software to websites or bulletin boards, inclusion in shareware compilations, and derivative works.\n\nIf you wish to share this application with others, simply point them to:\nhttp://www.kannadaocr.com/kanigha\n'Kanigha' is distributed AS IS, WITHOUT ANY WARRANTY, IMPLIED OR OTHERWISE.  Prakash B. V. is not responsible for any damage or loss this software may cause.\n\nREGISTRATION:\nNo regisrtration is required. But, if you need to be informed about any updates on Kanigha, then, you can send an email to bvprakash@gmail.com. You will then be notified if any new version of Kanigha is released.\n\nUSAGE:\n- There are 2 text boxes on the screen.\n- Type an english word on left box and hit enter. If present in the dictionary, the Kannada equivalent word(s) are displayed on the right side text box.\n- You can move between the 2 text boxes by TABbing.\n- You can even make a new entry into the dictionary by typing the english word and then, entering the Kannada equivalent word(s) in the Kannada text box.\n  You then hit CTRL-A, to add this entry into dictionary.\n\n- If you need to know the number of word in dictionary, hit CTRL-K\n\nCONTACT:\nIf you have any suggestions or feedback please, write to the below mentioned email address.\n\n\"Kanigha\" Copyright (c) 2012 Prakash B. V.\nwww.kannadaocr.com \nKaleido Software\nBannerughatta Road, Bengaluru 560076\nContact: bvprakash@gmail.com\nAll rights reserved.\n");
        this.ReadMeTextArea.setWrapStyleWord(true);
        this.ReadMeTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.ReadMeTextArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainWin.this.ReadMeTextAreaKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                MainWin.this.ReadMeTextAreaKeyReleased(evt);
            }
        });
        this.ReadMeScrollPane.setViewportView(this.ReadMeTextArea);
        this.ReadMeFrame.getContentPane().add((Component)this.ReadMeScrollPane, "Center");
        this.Message_jLabel.setFont(new Font("Tahoma", 0, 12));
        this.Message_jLabel.setForeground(Color.blue);
        this.Message_jLabel.setText("  ");
        this.MainWinFile_jMenu.setText("File");
        this.MainWinFile_Readme_jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.MainWinFile_Readme_jMenuItem.setText("ReadMe");
        this.MainWinFile_Readme_jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWin.this.MainWinFile_Readme_jMenuItemActionPerformed(evt);
            }
        });
        this.MainWinFile_jMenu.add(this.MainWinFile_Readme_jMenuItem);
        this.MainWinFile_Exit_jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.MainWinFile_Exit_jMenuItem.setText("Exit");
        this.MainWinFile_Exit_jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWin.this.MainWinFile_Exit_jMenuItemActionPerformed(evt);
            }
        });
        this.MainWinFile_jMenu.add(this.MainWinFile_Exit_jMenuItem);
        this.MainWin_jMenuBar.add(this.MainWinFile_jMenu);
        this.setJMenuBar(this.MainWin_jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(284, Short.MAX_VALUE).addComponent(this.Cright_jLabel).addGap(184, 184, 184)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.Message_jLabel, GroupLayout.Alignment.LEADING, -1, 610, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.EngWord, -2, 195, -2).addComponent(this.EngWordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 109, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.KannadaWordLabel).addComponent(this.KanWords_jScrollPane, -2, -1, -2)))).addGap(35, 35, 35)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 339, Short.MAX_VALUE).addComponent(this.ReadMeFrame, -2, -1, -2).addGap(0, 340, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(78, 78, 78).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.KannadaWordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.KanWords_jScrollPane, -2, 173, -2)).addGroup(layout.createSequentialGroup().addComponent(this.EngWordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.EngWord, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE).addComponent(this.Message_jLabel).addGap(18, 18, 18).addComponent(this.Cright_jLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 173, Short.MAX_VALUE).addComponent(this.ReadMeFrame, -2, 280, -2).addGap(0, 174, Short.MAX_VALUE))));
        this.KannadaWordLabel.getAccessibleContext().setAccessibleName("");
        this.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void MainWinFile_Exit_jMenuItemActionPerformed(ActionEvent evt) {
        this.SaveDictionary();
        System.exit(0);
    }

    private void MainWinFile_Readme_jMenuItemActionPerformed(ActionEvent evt) {
        this.ReadMeFrame.toFront();
        this.ReadMeFrame.setVisible(true);
    }

    private void KanWords_jTextAreaFocusGained(FocusEvent evt) {
        if (this.ReadMeFrame.isVisible()) {
            return;
        }
        this.InKanTexBox = true;
        this.KanWords_jTextArea.setBackground(Color.WHITE);
        this.KanWords_jTextArea.setCaretPosition(this.KanWords_jTextArea.getText().length());
    }

    private void EngWordFocusGained(FocusEvent evt) {
        if (this.ReadMeFrame.isVisible()) {
            return;
        }
        this.InKanTexBox = false;
        this.KanWords_jTextArea.setBackground(SystemColor.menu);
    }

    private void KanWords_jTextAreaKeyPressed(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        if (keyc == 9) {
            this.EngWord.selectAll();
            this.EngWord.requestFocus();
        } else if (this.CtrlKeyPressed && keyc == 65) {
            this.AddWordToDictionary();
        } else if (keyc == 17) {
            this.CtrlKeyPressed = true;
        }
    }

    private void EngWordKeyPressed(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        if (this.CtrlKeyPressed && keyc == 65) {
            this.AddWordToDictionary();
        } else if (this.CtrlKeyPressed && keyc == 86) {
            this.PasteText('e');
        } else if (this.CtrlKeyPressed && keyc == 75) {
            this.DisplayDictSize();
        } else if (keyc == 17) {
            this.CtrlKeyPressed = true;
        } else if (keyc == 116) {
            this.UpdateDictFromDict2();
        }
    }

    private void EngWordKeyReleased(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        if (keyc == 17) {
            this.CtrlKeyPressed = false;
        } else if (keyc == 10) {
            this.Message_jLabel.setText(null);
            String e_word = this.EngWord.getText().toLowerCase().trim();
            this.KanWords_jTextArea.setText(this.EngKanDict.get(e_word));
            this.EngWord.selectAll();
        }
    }

    private void KanWords_jTextAreaKeyReleased(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        if (keyc == 17) {
            this.CtrlKeyPressed = false;
        } else if (this.CtrlKeyPressed && keyc == 86) {
            this.PasteText('k');
        } else if (this.CtrlKeyPressed && keyc == 75) {
            this.DisplayDictSize();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.SaveDictionary();
        System.exit(0);
    }

    private void ReadMeTextAreaKeyPressed(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        if (keyc == 18) {
            this.readme_ALT_key_pressed = true;
        } else if (keyc == 67 && this.readme_ALT_key_pressed) {
            this.ReadMeFrame.dispose();
        }
    }

    private void ReadMeTextAreaKeyReleased(KeyEvent evt) {
        int keyc = evt.getKeyCode();
        if (keyc == 18) {
            this.readme_ALT_key_pressed = false;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainWin().setVisible(true);
            }
        });
    }

    boolean LoadDictionary() {
        int num = 0;
        try {
            String line;
            FileInputStream fstream = new FileInputStream("./ekdict.txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-16"));
            while ((line = br.readLine()) != null) {
                String[] words = line.split("=", 2);
                if (words.length != 2 || words[0].length() <= 1 || words[1].length() <= 1) continue;
                String word = words[0].toLowerCase().trim();
                String new_k_word = words[1].trim();
                String k_word = this.EngKanDict.get(word);
                ++num;
                if (k_word == null) {
                    this.EngKanDict.put(word, new_k_word);
                    continue;
                }
                if (k_word.length() + new_k_word.length() >= 400) continue;
                this.EngKanDict.put(word, k_word + ", " + new_k_word);
            }
            br.close();
            in.close();
            fstream.close();
            this.Message_jLabel.setText(num + " words in dictionary.");
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    void SaveDictionary() {
        if (!this.DictionaryModified) {
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("./ekdict.txt"), "UTF16"));
            for (String key : this.EngKanDict.keySet()) {
                out.write(key + "=" + this.EngKanDict.get(key));
                out.newLine();
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void AddWordToDictionary() {
        String e_word = this.EngWord.getText().trim().toLowerCase();
        String k_word = this.KanWords_jTextArea.getText().trim();
        String kuword = this.KTr.tranlit_to_kan(k_word);
        this.KanWords_jTextArea.setText(kuword);
        String k_word_in_dict = this.EngKanDict.get(e_word);
        if (k_word_in_dict == null) {
            this.Message_jLabel.setText("Adding " + e_word + " to dictionary");
        } else {
            this.Message_jLabel.setText("Updating word " + e_word + " in dictionary");
            this.EngKanDict.remove(e_word);
        }
        this.EngKanDict.put(e_word, kuword);
        this.DictionaryModified = true;
    }

    void PasteText(char area) {
        Transferable clipData = this.clipboard.getContents(this.clipboard);
        if (clipData != null) {
            try {
                if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                    if (area == 'k') {
                        this.KanWords_jTextArea.replaceSelection(s);
                    } else if (area == 'e') {
                        this.EngWord.replaceSelection(s);
                    }
                }
            }
            catch (UnsupportedFlavorException ufe) {
                System.err.println("Flavor unsupported: " + ufe);
            }
            catch (IOException ioe) {
                System.err.println("Data not available: " + ioe);
            }
        }
    }

    void UpdateDictFromDict2() {
        int num = 0;
        try {
            String line;
            FileInputStream fdict_2 = new FileInputStream("./ekdict_2.txt");
            DataInputStream in_2 = new DataInputStream(fdict_2);
            BufferedReader br_2 = new BufferedReader(new InputStreamReader((InputStream)in_2, "UTF-16"));
            while ((line = br_2.readLine()) != null) {
                String[] words = line.split("=", 2);
                if (words.length != 2 || words[0].length() <= 1 || words[1].length() <= 1) continue;
                String word = words[0].toLowerCase().trim();
                String new_k_word = words[1].trim();
                String k_word = this.EngKanDict.get(word);
                if (k_word != null) continue;
                ++num;
                this.EngKanDict.put(word, new_k_word);
            }
            br_2.close();
            in_2.close();
            fdict_2.close();
            if (num > 0) {
                this.DictionaryModified = true;
            }
            this.Message_jLabel.setText(num + " words added to dictionary from ekdict_2.txt.");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void DisplayDictSize() {
        this.Message_jLabel.setText(this.EngKanDict.size() + " words in dictionary.");
    }
}

